/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.palette;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepPaletteDefinition;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.palette.VWBaseStepPalettePanel;
import filenet.vw.toolkit.design.palette.VWDraggablePaletteItemUI;
import filenet.vw.toolkit.design.palette.VWEllipsisPaletteItemUI;
import filenet.vw.toolkit.design.palette.VWStepPaletteItemUI;
import filenet.vw.toolkit.design.palette.VWStepPaletteWrapper;
import filenet.vw.toolkit.design.palette.VWTextAnnotationPaletteItemUI;
import filenet.vw.toolkit.utils.VWPopupMenu;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class VWIconViewPanel
extends JPanel
implements MouseListener,
ComponentListener {
    private static final int GAP_HORIZONTAL = 1;
    private static final int GAP_VERTICAL = 1;
    private static final int BUFFER_WIDTH = 100;
    protected VWBaseStepPalettePanel m_stepPalettePanel = null;
    protected CompoundBorder m_defaultBorder = null;
    private VWTextAnnotationPaletteItemUI m_textAnnotationItem = null;
    private VWEllipsisPaletteItemUI m_ellipsisItem = null;
    private Vector<VWStepPaletteItemUI[]> m_stepPaletteArrays = null;

    public VWIconViewPanel(VWBaseStepPalettePanel stepPalettePanel) {
        this.m_stepPalettePanel = stepPalettePanel;
        this.setBackground(SystemColor.text);
        Border outsideBorder = BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1);
        Border insideBorder = BorderFactory.createLineBorder(Color.GRAY, 1);
        this.m_defaultBorder = new CompoundBorder(outsideBorder, insideBorder);
        this.setBorder(this.m_defaultBorder);
        if (this.m_stepPalettePanel != null) {
            this.m_textAnnotationItem = new VWTextAnnotationPaletteItemUI(this.m_stepPalettePanel.getAuthPropertyData());
            this.m_textAnnotationItem.addMouseListener(this);
            this.m_ellipsisItem = new VWEllipsisPaletteItemUI();
            this.m_ellipsisItem.addMouseListener(this);
        }
    }

    public synchronized void displayPalettes(VWStepPaletteWrapper[] stepPalettes) {
        try {
            this.m_stepPaletteArrays = new Vector();
            if (stepPalettes != null) {
                for (int nPaletteIndex = 0; nPaletteIndex < stepPalettes.length; ++nPaletteIndex) {
                    VWMapNode[] vwMapNodes;
                    VWStepPaletteDefinition vwStepPaletteDefinition = stepPalettes[nPaletteIndex].getStepPaletteDefinition();
                    if (vwStepPaletteDefinition == null || (vwMapNodes = vwStepPaletteDefinition.getSteps()) == null || vwMapNodes.length <= 0) continue;
                    Object[] spItems = new VWStepPaletteItemUI[vwMapNodes.length];
                    for (int nIndex = 0; nIndex < vwMapNodes.length; ++nIndex) {
                        spItems[nIndex] = this.makeItem(vwMapNodes[nIndex], stepPalettes[nPaletteIndex]);
                    }
                    VWQubbleSort.sort(spItems);
                    this.m_stepPaletteArrays.addElement((VWStepPaletteItemUI[])spItems);
                }
            }
            this.calculateSize();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyComponentOrientation(ComponentOrientation orientation) {
        super.applyComponentOrientation(orientation);
        VWBaseStepPalettePanel vWBaseStepPalettePanel = this.m_stepPalettePanel;
        synchronized (vWBaseStepPalettePanel) {
            if (this.m_stepPaletteArrays != null) {
                for (int i = 0; i < this.m_stepPaletteArrays.size(); ++i) {
                    VWStepPaletteItemUI[] obj = this.m_stepPaletteArrays.elementAt(i);
                    if (obj == null || !(obj instanceof VWStepPaletteItemUI[])) continue;
                    VWStepPaletteItemUI[] spItems = obj;
                    for (int j = 0; j < spItems.length; ++j) {
                        spItems[j].setComponentOrientation(orientation);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReferences() {
        if (this.m_textAnnotationItem != null) {
            this.m_textAnnotationItem.removeMouseListener(this);
            this.m_textAnnotationItem.releaseReferences();
            this.m_textAnnotationItem = null;
        }
        if (this.m_ellipsisItem != null) {
            this.m_ellipsisItem.removeMouseListener(this);
            this.m_ellipsisItem.releaseReferences();
            this.m_ellipsisItem = null;
        }
        VWBaseStepPalettePanel vWBaseStepPalettePanel = this.m_stepPalettePanel;
        synchronized (vWBaseStepPalettePanel) {
            if (this.m_stepPaletteArrays != null) {
                this.m_stepPaletteArrays.removeAllElements();
                this.m_stepPaletteArrays = null;
            }
        }
        this.m_defaultBorder = null;
        this.m_stepPalettePanel = null;
        this.removeAll();
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            Object source = event.getSource();
            if (source instanceof VWTextAnnotationPaletteItemUI) {
                if (this.m_stepPalettePanel != null) {
                    this.m_stepPalettePanel.getAuthPropertyData().getToolbarActionNotifier().notifyToolbarAction(this, 661, null);
                }
            } else if (source instanceof VWStepPaletteItemUI) {
                if (this.m_stepPalettePanel != null) {
                    VWMapNode newMapNode = ((VWStepPaletteItemUI)source).getMapNode();
                    this.m_stepPalettePanel.getAuthPropertyData().getToolbarActionNotifier().notifyToolbarAction(this, 660, newMapNode);
                }
            } else if (source instanceof VWEllipsisPaletteItemUI && this.m_stepPalettePanel != null) {
                this.m_stepPalettePanel.displayStepPaletteDialog();
            }
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (this.m_stepPalettePanel != null) {
            Object sourceObj;
            VWDraggablePaletteItemUI selectedUIItem = this.m_stepPalettePanel.getSelectedUIItem();
            if (selectedUIItem != null) {
                selectedUIItem.setSelected(false);
            }
            if ((sourceObj = event.getSource()) instanceof VWIconViewPanel) {
                this.m_stepPalettePanel.setSelectedUIItem(null);
            } else if (sourceObj instanceof VWDraggablePaletteItemUI) {
                selectedUIItem = (VWDraggablePaletteItemUI)sourceObj;
                selectedUIItem.setSelected(true);
                this.m_stepPalettePanel.setSelectedUIItem(selectedUIItem);
            }
        }
        if (event.isPopupTrigger()) {
            this.displayPopup(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.displayPopup(event);
        }
    }

    public void componentHidden(ComponentEvent event) {
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentResized(ComponentEvent event) {
        this.calculateSize();
    }

    public void componentShown(ComponentEvent event) {
    }

    protected void displayPopup(MouseEvent event) {
        VWPopupMenu popupMenu;
        VWDraggablePaletteItemUI paletteItemUI = this.m_stepPalettePanel.getSelectedUIItem();
        if (paletteItemUI == null) {
            return;
        }
        VWStepPaletteWrapper stepPaletteWrapper = paletteItemUI.getStepPaletteWrapper();
        if (stepPaletteWrapper != null && stepPaletteWrapper.isEditable() && (popupMenu = this.m_stepPalettePanel.getStepContextMenu()) != null) {
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    protected VWStepPaletteItemUI makeItem(VWMapNode vwMapNode, VWStepPaletteWrapper stepPaletteWrapper) {
        VWDesignerCoreData designerCoreData = this.m_stepPalettePanel.getAuthPropertyData().getDesignerCoreData();
        VWStepPaletteItemUI uiItem = new VWStepPaletteItemUI(vwMapNode, designerCoreData, stepPaletteWrapper);
        uiItem.setComponentOrientation(this.getComponentOrientation());
        uiItem.addMouseListener(this);
        return uiItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void calculateSize() {
        try {
            try {
                this.removeAll();
                this.setLayout(new GridBagLayout());
                GridBagConstraints gbCons = new GridBagConstraints();
                gbCons.gridx = 0;
                gbCons.gridy = 0;
                gbCons.fill = 0;
                gbCons.weightx = 0.0;
                gbCons.weighty = 0.0;
                gbCons.anchor = 22;
                gbCons.gridheight = 1;
                gbCons.gridwidth = 1;
                gbCons.insets = new Insets(1, 1, 1, 1);
                Dimension parentSize = this.getParent().getSize();
                int nAvailableWidth = parentSize.width - 100;
                Point location = this.getLocation();
                nAvailableWidth = this.getComponentOrientation().isLeftToRight() ? (nAvailableWidth -= location.x) : (nAvailableWidth -= parentSize.width - (this.getWidth() + location.x));
                if (nAvailableWidth > 0) {
                    this.add((Component)this.m_textAnnotationItem, gbCons);
                    Dimension preferredSize = this.m_textAnnotationItem.getPreferredSize();
                    nAvailableWidth -= preferredSize.width;
                    ++gbCons.gridx;
                    JLabel separatorLabel = new JLabel(VWImageLoader.createImageIcon("separator.gif"));
                    this.add((Component)separatorLabel, gbCons);
                    preferredSize = separatorLabel.getPreferredSize();
                    nAvailableWidth -= preferredSize.width;
                    ++gbCons.gridx;
                    preferredSize = this.m_ellipsisItem.getPreferredSize();
                    nAvailableWidth -= preferredSize.width;
                    if (this.m_stepPaletteArrays != null) {
                        block4: for (int nPaletteIndex = 0; nPaletteIndex < this.m_stepPaletteArrays.size(); ++nPaletteIndex) {
                            VWStepPaletteItemUI[] spItems = this.m_stepPaletteArrays.elementAt(nPaletteIndex);
                            for (int nIndex = 0; nIndex < spItems.length; ++gbCons.gridx, ++nIndex) {
                                preferredSize = spItems[nIndex].getPreferredSize();
                                if ((nAvailableWidth -= preferredSize.width) > 0) {
                                    this.add((Component)spItems[nIndex], gbCons);
                                    continue;
                                }
                                this.add((Component)this.m_ellipsisItem, gbCons);
                                ++gbCons.gridx;
                                continue block4;
                            }
                        }
                    }
                }
                this.setMaximumSize(this.getPreferredSize());
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var11_12 = null;
                this.revalidate();
                this.repaint();
                return;
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.revalidate();
            this.repaint();
            throw throwable;
        }
        this.revalidate();
        this.repaint();
    }
}

